# 指示点を円弧でつなぐ「雲囲い」作図スクリプト（円弧分割版）
BEGIN {
sa = 0 # 始角
ea = 180 # 終角
ratio = 1 # 偏平率
arc_div = 3 # 各指示点間を何個の円弧でつなぐか
div = 18 # 各円弧の分割数
}
# hp座標を読み込み
/^hp[0-9]+/ {
n++
x[n] = $2
y[n] = $3
}
END {
pi = atan2(0,-1)
if (n < 2) exit
print "lc10 255"
print "pl"
for (i = 1; i <= n; i++) {
j = (i < n) ? i + 1 : 1 # 次の点（最後は1に戻る）
dx = x[j] - x[i]
dy = y[j] - y[i]
dist = sqrt(dx*dx + dy*dy)
ang = atan2(dy, dx) * 180 / pi
# 分割ごとのステップ
stepx = dx / arc_div
stepy = dy / arc_div
seg = dist / arc_div
for (k = 0; k < arc_div; k++) {
# 各小区間の中心座標
x1 = x[i] + stepx * k
y1 = y[i] + stepy * k
x2 = x[i] + stepx * (k + 1)
y2 = y[i] + stepy * (k + 1)
mx = (x1 + x2) / 2
my = (y1 + y2) / 2
r = seg / 2
da = ea - sa
if (da <= 0) da += 360 # 角度補正
ang_a = ang * pi/180
cos_a = cos(ang_a)
sin_a = sin(ang_a)
for (g = 0; g <= div; g++) {
angl = (sa +(ea-sa) * g / div) * pi/180
xr = r * cos(angl)
yr = r * sin(angl) * ratio
xx = mx + xr * cos_a - yr * sin_a
yy = my + xr * sin_a + yr * cos_a
if (g > 0){
printf("sl %f %f %f %f\n", px, py, xx, yy)
}
px = xx; py = yy
}
}
}
print "#"
}